package com.company.tp07_02_localtodoapp2.view;

import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;

import androidx.appcompat.app.AppCompatActivity;

import com.company.tp07_02_localtodoapp2.R;


public class AddTodoActivity extends AppCompatActivity {
    public static final String EXTRA_REPLY ="com.example.localtodoapp.view.REPLY";
    private EditText title;
    private Button button;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_add_todo);

        title = (EditText) findViewById(R.id.title);
        button = (Button) findViewById(R.id.button);
        button.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent replyIntent = new Intent();
                if (TextUtils.isEmpty(title.getText())) {
                    setResult(RESULT_CANCELED, replyIntent);
                } else {
                    String text = title.getText().toString();
                    replyIntent.putExtra(EXTRA_REPLY, text);
                    setResult(RESULT_OK, replyIntent);
                }
                finish();

            }
        });
    }
}
